//
//  CommonDraw.h
//  ImageX
//
//  Created by Yaroslav Glushchenko on 5/10/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// Rendering
//////////////////////////////////////////////////////////////////////
@interface CRCommonDraw : NSObject
{
}

+ (NSRect)keepRectInAspect:(NSRect)rcImage withImageSize:(NSSize)imageSize;
+ (NSRect)keepRectInAspectByExtend:(NSRect)rcImage withImageSize:(NSSize)imageSize;

+ (NSRect)adjustRect:(NSRect)rect toFitRect:(NSRect)otherRect onSide:(int)side fitInside:(BOOL)inside keepMinimum:(BOOL)keepMinimum;

+ (void)drawText:(NSString*)text fitToRect:(NSRect)rect ofColor:(NSColor*)color shadowColor:(NSColor*)shadowColor;
+ (void)drawText:(NSString*)text fontName:(NSString *)fontName fitToRect:(NSRect)rect ofColor:(NSColor*)color shadowColor:(NSColor*)shadowColor;

@end

//////////////////////////////////////////////////////////////////////
// Functions
//////////////////////////////////////////////////////////////////////
CGPatternRef	CreateImagePattern(CGImageRef image);
CGColorRef		CreatePatternColor(CGImageRef image);